<?php

//require_once 'auth.php';
require_once 'config.php';
require_once 'models/ApiUser.php';
require_once 'DatabaseConnector.php';
require_once 'dao/ApiUserDao.php';
require_once 'ApiUserService.php';

if(!isset($_POST['name'], $_POST['user_id'])) {
    http_response_code(400);
    die("Wrong params...");
}

$apiUser = new ApiUser();

$apiUser->setName(secureInput($_POST['name']));
$apiUser->setPassword(generateRandomString(50));
$apiUser->setUserId(secureInput($_POST['user_id']));


$databaseConnector = new DatabaseConnector(DB_DATABASE, DB_USER, DB_PASSWORD, DB_HOST);
$apiUserService = new ApiUserService(new ApiUserDao($databaseConnector->getConnection()));

if($apiUserService->save($apiUser)) {
    http_response_code(200);
    header("Location: advanced-settings.php");
}
else {
    http_response_code(400);
    header("Location: advanced-settings");
}

function generateRandomString($length = 10) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}

